clear all
clc

% Nonlinear map: max/(1 + [(x-centx) (y-centy)]P[(x-centx) (y-centy)]')^root

% Simulation parameters
    tmax   =150;        % max simulation time
    deltaT = .01;       % simulation time step
    ICx = 1;            % initial x-coordinate in x-y plane
    ICy = 1;            % initial y-coordinate in x-y plane
    
% Nonlinear map parameters
    max = 1;            % max value of nonlinear map
    centx = -1;          % x-coordinate of center of nonlinear map
    centy = -1;          % y-coordinate of center of nonlinear map    
    p1 = 1;             % values in Hessian (P)
    p2 = 1/2;   
    p12 = 0;
    p21 = 0;
    root = 1;           % can be used to spread map
    
    omega=0.1;

% Extremum Seeking parameters
    wx = 20;            % x-loop perturbation frequency
    ax = .05;           % x-loop perturbation amplitude
    cx = 10;            % x-loop gain

    wy = 20;            % y-loop perturbation frequency
    ay = .05;           % y-loop perturbation amplitude
    cy = 10;            % y-loop gain
    
    wo=wx;
   % omega<<ax*qx*cx
   
   
   
%    plot(centerx,centery,'r--',X,Y,'-.','LineWidth',3)
%    plot(X,Y,'-.','LineWidth',2)
%    figure 
%    plot(T,MAX,'LineWidth',2)
%    xlabel('time(sec)','FontSize',18,'FontWeight','bold');
%    title('y','FontSize',18,'FontWeight','bold');
%    grid on;  
%    set(gca,'FontSize',12,'FontWeight','bold'); 